/*
 * Decompiled with CFR 0.152.
 */
package test01;

import test01.Queue;
import test01.UnderflowException;

class ArrayQueue
implements Queue {
    private Object[] theArray = new Object[10];
    private int currentSize;
    private int front;
    private int back;
    private static final int DEFAULT_CAPACITY = 10;

    public ArrayQueue() {
        this.makeEmpty();
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        this.front = 0;
        this.back = -1;
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayQueue dequeue");
        }
        --this.currentSize;
        Object returnValue = this.theArray[this.front];
        this.front = this.increment(this.front);
        return returnValue;
    }

    public Object getFront() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayQueue getFront");
        }
        return this.theArray[this.front];
    }

    public void enqueue(Object x) {
        if (this.currentSize == this.theArray.length) {
            this.doubleQueue();
        }
        this.back = this.increment(this.back);
        this.theArray[this.back] = x;
        ++this.currentSize;
    }

    private int increment(int x) {
        if (++x == this.theArray.length) {
            x = 0;
        }
        return x;
    }

    private void doubleQueue() {
        Object[] newArray = new Object[this.theArray.length * 2];
        for (int i = 0; i < this.currentSize; ++i) {
            newArray[i] = this.theArray[this.front];
            this.front = this.increment(this.front);
        }
        this.theArray = newArray;
        this.front = 0;
        this.back = this.currentSize - 1;
    }
}

