/*
 * Decompiled with CFR 0.152.
 */
package test01;

import test01.ResponseParser;
import test01.StringReader;
import test01.TaxistState;

public class TaxistStateParser
extends ResponseParser {
    private final TaxistState state;

    TaxistStateParser(TaxistState p_state) {
        this.state = p_state;
    }

    public void parseResponse(String src) {
        StringReader sr = new StringReader(src);
        String s = sr.readString();
        while (s != null) {
            if (s.equals("current_order_state")) {
                this.state.current_order_state = Integer.parseInt(sr.readString());
            } else if (s.equals("last_sync")) {
                this.state.last_sync = Double.parseDouble(sr.readString());
            } else if (s.equals("waiting_for_assign")) {
                this.state.flag_waiting_for_assign = true;
            } else if (s.equals("waiting_for_cancel")) {
                this.state.flag_waiting_for_cancel = true;
            } else if (s.equals("current_order")) {
                this.state.current_order.parse(sr);
            } else if (s.equals("current_big_region")) {
                this.state.current_big_region = Integer.parseInt(sr.readString());
            } else if (s.equals("delayed_order") && this.state.delayed_orders_count < 20) {
                ++this.state.delayed_orders_count;
                this.state.delayed_orders[this.state.delayed_orders_count - 1].parse(sr);
            } else if (s.equals("access_denied")) {
                this.state.access_denied = true;
                break;
            }
            s = sr.readString();
        }
    }
}

