/*
 * Decompiled with CFR 0.152.
 */
package test01;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import test01.ErrorHandler;
import test01.Hello;
import test01.OkHandler;
import test01.ResponseParser;

class UrlRequestor
implements Runnable {
    private final String url;
    private final ResponseParser parser;
    private final Hello midlet;
    private final OkHandler okHandler;
    private final ErrorHandler errorHandler;

    UrlRequestor(Hello p_midlet, String p_url, ResponseParser p_parser, OkHandler p_okHandler, ErrorHandler p_errorHandler) {
        this.midlet = p_midlet;
        this.url = p_url;
        this.parser = p_parser;
        this.okHandler = p_okHandler;
        this.errorHandler = p_errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpConnection hc = null;
        InputStream dis = null;
        if (this.okHandler != null) {
            this.okHandler.setParser(this.parser);
        }
        try {
            int ch;
            hc = (HttpConnection)Connector.open((String)this.url);
            dis = hc.openInputStream();
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            while ((ch = dis.read()) != -1) {
                bytestream.write(ch);
            }
            String response = new String(bytestream.toByteArray(), "UTF-8");
            bytestream.close();
            if (this.parser != null) {
                this.parser.parseResponse(response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.errorHandler != null) {
                this.midlet.display.callSerially((Runnable)this.errorHandler);
            }
            return;
        }
        finally {
            if (hc != null) {
                try {
                    hc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.okHandler != null) {
            this.midlet.display.callSerially((Runnable)this.okHandler);
        }
    }
}

